/*:
 * @plugindesc タイトル画面のコマンドを残します。
 * @author hisamon
 */

(function() {

  // ニューゲーム時の処理（フェード＋遅延）
  Scene_Title.prototype.commandNewGame = function() {
    SoundManager.playOk();
    this._commandWindow.deactivate();
    this.fadeOutAll();
    this._startCountdown = 60; // 1秒後にゲーム開始
  };

  // コンティニュー時の処理（即遷移）
  Scene_Title.prototype.commandContinue = function() {
    SoundManager.playOk();
    this._commandWindow.deactivate();
    SceneManager.push(Scene_Load);
  };

  // オプション時の処理（即遷移）
  Scene_Title.prototype.commandOptions = function() {
    SoundManager.playOk();
    this._commandWindow.deactivate();
    SceneManager.push(Scene_Options);
  };

  // ゲーム終了時の処理（フェード＋遅延）
  Scene_Title.prototype.commandExit = function() {
    SoundManager.playOk();
    this._commandWindow.deactivate();
    this.fadeOutAll();
    this._exitCountdown = 60; // 1秒後に終了
  };

  // update 処理で遷移を監視
  const _Scene_Title_update = Scene_Title.prototype.update;
  Scene_Title.prototype.update = function() {
    _Scene_Title_update.call(this);

    // ニューゲーム遅延実行
    if (this._startCountdown !== undefined && this._startCountdown > 0) {
      this._startCountdown--;
      if (this._startCountdown <= 0) {
        DataManager.setupNewGame();
        SceneManager.goto(Scene_Map);
      }
    }

    // 終了遅延実行
    if (this._exitCountdown !== undefined && this._exitCountdown > 0) {
      this._exitCountdown--;
      if (this._exitCountdown <= 0) {
        SceneManager.exit();
      }
    }
  };

})();